/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.statemachine.alakarkinos;

import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.common.entity.Alakarkinos;
import com.hollingsworth.arsnouveau.common.entity.statemachine.alakarkinos.ConvertBlockState;
import com.hollingsworth.arsnouveau.common.entity.statemachine.alakarkinos.CrabState;
import com.hollingsworth.arsnouveau.common.entity.statemachine.alakarkinos.DecideCrabActionState;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketAnimEntity;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class PlaceHatState
extends CrabState {
    BlockPos placeHatPos;
    int placeTries;
    boolean didHatAnimate;
    int waitTicks;
    boolean placedHat;
    BlockPos convertStatePos;

    public PlaceHatState(Alakarkinos alakarkinos, BlockPos placeHatPos, BlockPos convertStatePos) {
        super(alakarkinos);
        this.placeHatPos = placeHatPos;
        this.convertStatePos = convertStatePos;
    }

    public static BlockPos findHatPos(Alakarkinos alakarkinos) {
        for (BlockPos b : BlockPos.withinManhattan((BlockPos)alakarkinos.getHome(), (int)3, (int)1, (int)3)) {
            if (!alakarkinos.level.getBlockState(b).canBeReplaced() || alakarkinos.isColliding(b, BlockRegistry.CRAB_HAT.defaultBlockState())) continue;
            return b.immutable();
        }
        return null;
    }

    @Override
    public void onEnd() {
        this.alakarkinos.lookAt = null;
    }

    @Override
    @Nullable
    public CrabState tick() {
        super.tick();
        if (this.placeHatPos == null) {
            if (this.placeTries > 4) {
                return new DecideCrabActionState(this.alakarkinos);
            }
            this.placeHatPos = PlaceHatState.findHatPos(this.alakarkinos);
            return null;
        }
        this.alakarkinos.lookAt = Vec3.atCenterOf((Vec3i)this.placeHatPos);
        if (!this.didHatAnimate) {
            this.alakarkinos.getNavigation().moveTo((double)this.placeHatPos.getX() + 0.5, (double)this.placeHatPos.getY() + 0.5, (double)this.placeHatPos.getZ(), 1.0);
            if (BlockUtil.distanceFrom(this.alakarkinos.blockPosition(), this.placeHatPos) <= 2.0 || this.ticksRunning > 200) {
                this.didHatAnimate = true;
                this.alakarkinos.getNavigation().stop();
                this.waitTicks = 20;
                Networking.sendToNearbyClient(this.alakarkinos.level, (Entity)this.alakarkinos, (CustomPacketPayload)new PacketAnimEntity(this.alakarkinos.getId(), 0));
            }
            return null;
        }
        if (this.waitTicks > 0) {
            --this.waitTicks;
            return null;
        }
        if (!this.placedHat) {
            if (this.alakarkinos.level.getBlockState(this.placeHatPos).canBeReplaced()) {
                this.alakarkinos.level.setBlock(this.placeHatPos, BlockRegistry.CRAB_HAT.defaultBlockState(), 3);
                this.placedHat = true;
                this.alakarkinos.hatPos = this.placeHatPos.immutable();
                this.alakarkinos.getEntityData().set(Alakarkinos.HAS_HAT, (Object)Boolean.FALSE);
            } else {
                this.placeHatPos = null;
                return null;
            }
        }
        return new ConvertBlockState(this.alakarkinos, this.convertStatePos);
    }
}

